package gov.va.med.mhv.usermgmt.persist.ldap;

import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;

/**
 * Home for useful utilities used by LDAP-related classes. 
 *
 * @author Jon Crater Apr 5, 2006 2:40:05 PM
 */
public class LdapUtil {
	private static LdapEnvironment env = LdapEnvironment.getInstance();

	/**
	 * Build a distinguished name that points to an existing user entry.
	 * @param userName
	 * @return String The distinguished name in the format: uid=joeuser,ou=people,dc=heva,dc=va,dc=gov
	 */
	public static String buildUserDn(String uid) {
		StringBuffer buf = new StringBuffer(env.getUserNameAttribute()).append('=').append(uid).append(',').append(env.getUserBaseDn());

		return buf.toString();
	}

	/**
	 * Create a connection to the configured directory server.  This method should be 
	 * used by test cases and the LdapPoolableObjectFactory only.  To perform directory
	 * operations, use an appropriate LdapCommand instance.
	 */
	public static LDAPConnection createConnection() throws LDAPException {
		LDAPConnection conn = new LDAPConnection();
		conn.connect(env.getHost(), env.getPort(), env.getAdminPrincipal(), env.getAdminPassword());
		return conn;
	}

	/**
	 * Destroy an LDAPConnection instance.  This method should only be called by the appropriate
	 * <code>PoolableObjectFactory</code> intance responsible for managing the lifecycle
	 * of the <code>LDAPConnection</code> instances that are pooled.
	 * @param connection
	 */
	public static void destroyConnection(LDAPConnection connection) throws LDAPException {
		connection.disconnect();
	}

	// prevent instantiation
	private LdapUtil() {
	}
}
